
// -------------------- Pico Library --------------------

// Pico Library - Header File

// All code (c) Copyright 2004 Dave, All rights reserved.
// Free for non-commercial use.

// For commercial use, separate licencing terms must be obtained.

#ifdef __cplusplus
extern "C" {
#endif

// Pico.cpp
extern int PicoVer;
int PicoInit();
void PicoExit();
int PicoReset();
int PicoFrame();
extern int PicoPad[2]; // Joypads, format is SACB RLDU

// Area.cpp
struct PicoArea { void *data; int len; char *name; };
extern int (*PicoAcb)(struct PicoArea *); // Area callback for each block of memory
// &1=for reading &2=for writing &4=volatile &8=non-volatile
int PicoAreaScan(int action,int *pmin);
int PicoSaveLoad(FILE *file,int action); // Action: 5=Save, 6=Load

// Cart.cpp
int PicoCartLoad(FILE *f,unsigned char **prom,unsigned int *psize);
int PicoCartInsert(unsigned char *rom,unsigned int romsize);

// Draw.cpp
extern int (*PicoCram)(int cram); // Callback to convert colour ram 0000bbb0 ggg0rrr0
extern int (*PicoScan)(unsigned int num,unsigned short *pal,unsigned char *data);

// Sek.cpp
extern char PicoStatus[];

// Sound.cpp
extern int PsndRate,PsndLen;
extern short *PsndOut;

#ifdef __cplusplus
} // End of extern "C"
#endif
